<?php
require 'vendor/autoload.php';
use Razorpay\Api\Api;

// Razorpay API credentials
$razorpay_test_key = "your_test_key";
$razorpay_test_secret_key = "your_test_secret_key";
$webhookSecret = "your_webhook_secret"; // Set this in Razorpay Dashboard

// Read the request body
$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

// Verify webhook signature
$providedSignature = $_SERVER['HTTP_X_RAZORPAY_SIGNATURE'] ?? '';
$expectedSignature = hash_hmac('sha256', $inputJSON, $webhookSecret);

if ($providedSignature !== $expectedSignature) {
    error_log("❌ Invalid Webhook Signature");
    http_response_code(403);
    exit();
}

// Log webhook data for debugging
file_put_contents("webhook_log.txt", json_encode($input, JSON_PRETTY_PRINT), FILE_APPEND);

// Check if webhook data is valid
if (!$input || !isset($input['event'])) {
    error_log("❌ Invalid Webhook Data");
    http_response_code(400);
    exit();
}

// Process Razorpay Webhook Events
switch ($input['event']) {
    case 'payment.captured':
        $payment_id = $input['payload']['payment']['entity']['id'];
        $order_id = $input['payload']['payment']['entity']['order_id'];
        $amount = $input['payload']['payment']['entity']['amount'] / 100; // Convert to INR
        $status = $input['payload']['payment']['entity']['status'];

        // Verify payment using Razorpay API
        $api = new Api($razorpay_test_key, $razorpay_test_secret_key);
        $payment = $api->payment->fetch($payment_id);

        if ($payment->status === 'captured') {
            update_order_payment_status($order_id, "Success", $payment_id, $amount);
        }
        break;

    case 'payment.failed':
        $order_id = $input['payload']['payment']['entity']['order_id'];
        update_order_payment_status($order_id, "Failed", null, 0);
        break;

    default:
        error_log("⚠️ Unhandled Webhook Event: " . $input['event']);
}

// Send response to Razorpay (must return 200)
http_response_code(200);

/**
 * Update order payment status in the database
 */
function update_order_payment_status($order_id, $status, $payment_id, $amount) {
    try {
        $pdo = new PDO("mysql:host=localhost;dbname=razorpay", "root", "Muse@123", [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ]);
        
        $stmt = $pdo->prepare("UPDATE orders SET payment_status = ?, razorpay_payment_id = ?, amount_paid = ? WHERE razorpay_order_id = ?");
        $stmt->execute([$status, $payment_id, $amount, $order_id]);

        error_log("✅ Order Updated: ID: $order_id | Status: $status | Payment ID: $payment_id | Amount: ₹$amount");
    } catch (PDOException $e) {
        error_log("❌ Database Error: " . $e->getMessage());
    }
}
?>
