<?php
// Dynamic article details (these would normally come from a database)

// Encode the URL for sharing
$articleId = 1;
// $articleUrl = "https://guidewiredevtrails.com/share-post/winner.php?id=" . urlencode($articleId);
$articleUrl = "https://musevps.com/knowledgebase/share-post/winner.php?id=" . urlencode($articleId);
$linkedinShareUrl = "https://www.linkedin.com/shareArticle?mini=true&url=". urlencode($articleUrl);
// $linkedinShareUrl = "https://www.linkedin.com/sharing/share-offsite/?url=" . urlencode($articleUrl);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Winners List</title>

    <!-- Open Graph Meta Tags for LinkedIn -->
    <meta property="og:title" content="Congratulations to Our Winners!">
    <meta property="og:description" content="Check out the list of our top winners.">
    <meta property="og:image" content="https://example.com/winners_banner.jpg">
    <meta property="og:url" content="https://example.com/winners.php?id=1">

    <!-- CSS Styles -->
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 20px;
            text-align: center;
        }
        table {
            width: 50%;
            margin: auto;
            border-collapse: collapse;
            background: #fff;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow: hidden;
        }
        th, td {
            padding: 12px;
            border: 1px solid #ddd;
            text-align: left;
        }
        th {
            background: #0077b5;
            color: white;
            font-size: 18px;
        }
        tr:nth-child(even) {
            background: #f9f9f9;
        }
        tr:hover {
            background: #e0e0e0;
        }
        .share-btn {
            display: inline-block;
            background: #0077b5;
            color: white;
            padding: 8px 12px;
            border-radius: 4px;
            text-decoration: none;
            font-size: 14px;
            transition: 0.3s;
        }
        .share-btn:hover {
            background: #005582;
        }
    </style>
</head>
<body>

    <h2>🏆 Winners List 🏆</h2>

    <!-- LinkedIn Share Button -->
    <a href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo urlencode('https://example.com/winners.php'); ?>" 
       target="_blank" class="share-btn">
       Share on LinkedIn
    </a>

    <br><br>

    <table>
        <tr>
            <th>Winner Name</th>
            <th>Prize</th>
        </tr>

        <?php
        // Example winners list (replace this with database records)
        $winners = [
            ['name' => 'John Doe', 'prize' => 'Gold Medal'],
            ['name' => 'Jane Smith', 'prize' => 'Silver Medal'],
            ['name' => 'Michael Brown', 'prize' => 'Bronze Medal'],
        ];

        foreach ($winners as $winner) {
            echo "<tr>";
            echo "<td>" . $winner['name'] . "</td>";
            echo "<td>" . $winner['prize'] . "</td>";
            echo "</tr>";
        }
        ?>

    </table>

</body>
</html>
