<?php
// Winners data (replace this with database query results)
$winners = [
    ['name' => 'John Doe', 'prize' => 'Gold Medal'],
    ['name' => 'Jane Smith', 'prize' => 'Silver Medal'],
    ['name' => 'Michael Brown', 'prize' => 'Bronze Medal'],
];

// Generate a dynamic description based on winners
$winnerNames = array_column($winners, 'name');
$winnerText = implode(', ', $winnerNames);
$metaDescription = "Congratulations to our winners: " . $winnerText;

// Define dynamic Open Graph data
$articleId = 1;
$articleTitle = "🏆 Winners Announcement!";

$articleDescription = "Congratulations to our winners: " . $winnerText."We want to send a big thank you to everyone who participated in our contest and helped make it a success!**

**And a special congratulations to Amy Smith, the winner of the $500 Wishpond Gift Card Grand Prize in our ‘$500 Summer Giveaway’ contest!. Her photo entry (see below) received 500 votes, the most of any entrant, and has been crowned the winner!";

// $articleImage = "https://guidewiredevtrails.com/share-post/images/img1.jpg";
// $articleUrl = "https://guidewiredevtrails.com/share-post/winner.php?id=" . urlencode($articleId);
$articleImage = "https://musevps.com/knowledgebase/share-post/images/img1.jpg";
$articleUrl = "https://musevps.com/knowledgebase/share-post/winner.php?id=" . urlencode($articleId);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Winners Announcement</title>

    <!-- Open Graph Meta Tags for LinkedIn -->
    <meta property="og:title" content="<?= htmlspecialchars($articleTitle) ?>">
    <meta property="og:description" content="<?= htmlspecialchars($articleDescription) ?>">
    <meta property="og:image" content="<?= $articleImage ?>">
    <meta property="og:url" content="<?= $articleUrl ?>">
    <meta property="og:type" content="article">

    <!-- CSS Styles -->
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            text-align: center;
        }
        table {
            width: 50%;
            margin: auto;
            border-collapse: collapse;
            background: #fff;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow: hidden;
        }
        th, td {
            padding: 12px;
            border: 1px solid #ddd;
            text-align: left;
        }
        th {
            background: #0077b5;
            color: white;
        }
    </style>
</head>
<body>

    <h2>🏆 Congratulations to Our Winners! 🏆</h2>
    <p><?= htmlspecialchars($metaDescription) ?></p>

</body>
</html>
